// http://stackoverflow.com/questions/26659042/unit-testing-a-directive-with-parsers-and-formatters
define(['angular', 'FormattedEmptyStringToNullValue'], function() {
	'use strict';
	describe('Formatted Empty String To Null Directive', function () {
		var scope,
			element,
			select;

		beforeEach(function () {
			module('angularTemplateApp');

			inject(function($rootScope, $compile) {
				scope = $rootScope.$new();
				//Must be an object to make use of prototypical inheritence for outside-of-isolate-scope access
				scope.models = {};
				scope.lastSeenMenu = [
					{value: 200, days: "200"},
					{value: 100, days: "100"}
				];

				element = angular.element('<form name="directiveTestForm">' +
						'<select formatted-empty-string-to-null-value name="total" ng-model="models.total" ng-options="lastSeen.value as lastSeen.days for lastSeen in lastSeenMenu">' +
							'<option value="">Select</option>' +
						'</select>' +
					'</form>');

				$compile(element)(scope);
				scope.$digest();

				select = element.find('select');
			});
		});

		describe('the parser', function () {
			it('should parse null to empty string', function () {
				select.find('option:first-of-type').prop('selected', true);
				select.trigger('change');
				expect(scope.models.total).toBe('');
			});

			// tested in automated test, unable to trigger change to empty string
			// -- it 'should parse empty strings to zero values and set as invalid'
		});

		describe('the formatter', function () {
			it('should leave empty string values as-is', function () {
				scope.models.total = 200;
				scope.$digest();
				expect(select.find('option:selected').text()).toBe('200');
			});

			it('should format empty string as null, selecting the default option', function () {
				scope.models.total = '';
				scope.$digest();
				expect(select.find('option:selected').text()).toBe('Select');
			});
		});
	});
});